# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 2
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR2_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if len(my_history) == 0:
        return "C"  # First move: Cooperate
    
    current_round = len(my_history) + 1
    
    if current_round == 10:
        return "D"  # Final round: Defect unconditionally
    
    if current_round == 9:
        return "C"  # Penultimate round: Cooperate to encourage cooperation
    
    if 2 <= current_round <= 5:
        # Early rounds: Modified Tit-for-Tat with 10% chance to defect
        if random.random() < 0.1:
            return "D"
        else:
            return opp_history[-1]
    
    if 6 <= current_round <= 8:
        # Middle rounds: Check if opponent defected more than twice in last 5 rounds
        if len(opp_history) >= 5 and sum(1 for move in opp_history[-5:] if move == "D") > 2:
            return "D"
        else:
            if random.random() < 0.1:
                return "D"
            else:
                return opp_history[-1]
    
    # Default fallback (shouldn't reach here)
    return opp_history[-1]